
/************************************************************************
 *																								*
 *		D48 8048/41 Disassembler - Copyright (C) 1995-1996 by					*
 *		Jeffery L. Post																	*
 *		22726 Benner Ave.																	*
 *		Torrance, CA  90505																*
 *																								*
 *		D48.H - Header File																*
 *																								*
 *		Version 2.0 - 08/19/96															*
 *																								*
 *	This program is free software; you can redistribute it and/or modify	*
 *	it under the terms of the GNU General Public License as published by	*
 *	the Free Software Foundation; either version 2 of the License, or		*
 *	(at your option) any later version.												*
 *																								*
 *	This program is distributed in the hope that it will be useful,		*
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of			*
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *	GNU General Public License for more details.									*
 *																								*
 *	You should have received a copy of the GNU General Public License		*
 *	along with this program; if not, write to the Free Software				*
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.				*
 *																								*
 ************************************************************************/

#define	MSDOS		/* Uncomment this for machines with segmented CPU
							architectures. For intelligently designed CPUs,
							we can use malloc instead of farmalloc for 64K
							byte arrays. */

/*#define	LINUX*/		/* Linux has no stricmp library function, must use
							strcasecmp instead. */

/*-----------------------------------------------------------------------

  Command line options:

	D - Generate comment field with address and data values.

	B - Force binary source file.

	H - Force hex source file.

	S - Change 'db' and 'dw' strings to 'defb' and 'defw'.

	1 - Disassemble 8041 code.

-------------------------------------------------------------------------

  Control codes allowed in the CTL file:

	A - Address			Specifies that the word entry is the address of
							something for which a label should be generated.

	B - Byte binary	Eight bit binary data (db).

	C - Code				Executable code.

	I - Ignore			Treat as uninitialized space. Will not be dis-
							assembled as code or anything else.

	L - Label			Generate a label for an address.

	R - Register		Specify name for a register.

	S - Symbol			Generate a symbol for a value.

	T - Text				ASCII text (db).

	W - Word binary	Sixteen bit binary data (db).

	The difference between labels and symbols is that a label refers
	to a referenced address, whereas a symbol may be used for 8 or 16
	bit immediate data. For some opcodes (eg: mov r2,#xx) only the symbol
	table will be searched. Other opcodes (eg: mov dptr,#) will search
	the label table first and then search the symbol table only if the
	value is not found in the label table.

-------------------------------------------------------------------------

  Exit codes:

	0 - No error (good disassembly).

	1 - File error (source file not found or disk full).

	2 - Error in control file.

-------------------------------------------------------------------------

	Definition of pflg bits:	pflg = 0xff if not initialized.
										pflg = 0 when initialized by input file.

	bit 7		set if uninitialized space.
	bit 6		address data
	bit 5		word binary data
	bit 4		byte binary data
	bit 3		clear if address is referenced (see bit 0)
	bit 2		ascii text
	bit 1		set if split opcode
	bit 0		set if address is referenced (see bit 3)

	Two bits (3 and 0) are needed to flag a referenced address because
		such a reference could be to initialized or uninitialized code
		space. If we used a single bit, we could not distinguish between
		a reference and uninitialized space. Bit 3 set with bit 0 clear
		indicates that the control file has specified this area as code.

  Flags entry in opcode table:

	0 = single byte opcode, no options
	1 = double byte, immediate data
	2 = double byte, current page address (djnz, jnz, etc)
	3 = double byte, extended address (jmp and call)
	4 = single byte, invalid opcode (will become DB in output)
	7 = unconditional transfer code (JMP, RET, etc)

-------------------------------------------------------------------------*/

#define	VERNO		2
#define	REVNO		0

#define	byte		unsigned char
#define	word		unsigned short

#define	PSIZE			4096
#define	ASTOP			56								/* ascii stop */
#define	TSTOP			16
#define	XSTOP			49

#define	EITHERFILE	0
#define	HEXFILE		1
#define	BINFILE		2

#define	GOOD_EXIT	0
#define	MEM_ERROR	1
#define	FILE_ERROR	2
#define	USER_ERROR	3

#define	SYMBOL		0
#define	LABEL			1

#define	ASCLINE		32		/* max length of ascii defb line		*/
#define	ASCLIMIT		512	/* size of ascii buffer					*/
#define	BYTELINE		8		/* max length of binary defb line	*/
#define	BYTELIMIT	512	/* size of byte binary buffer			*/
#define	WORDLINE		6		/* max length of defw line				*/
#define	WORDLIMIT	512	/* size of word binary buffer			*/
#define	NO_DATA		0xff	/* pmem uninitialized value			*/

/* pflag bits: */

#define	PF_INIT		0xff	/* initial value					*/
#define	PF_DATA		0x00	/* data valid from file			*/
#define	PF_NOINIT	0x80	/* set if uninitialized space	*/
#define	PF_ADRS		0x40	/* address data					*/
#define	PF_WORD		0x20	/* word binary data				*/
#define	PF_BYTE		0x10	/* byte binary data				*/
#define	PF_CLREF		0x08	/* clear if referenced			*/
#define	PF_ASCII		0x04	/* ascii text						*/
#define	PF_SPLIT		0x02	/* set if split opcode			*/
#define	PF_REF		0x01	/* set if referenced				*/

/* option table values: */

#define	OPT_XFER		0x80	/* unconditional transfer		*/
#define	OPT_INVAL	0x04	/* invalid opcode					*/
#define	OPT_EXT		0x03	/* extended memory reference	*/
#define	OPT_PAGE		0x02	/* memory ref in current page	*/
#define	OPT_IMM		0x01	/* immediate data					*/
#define	OPT_NONE		0x00	/* single byte, no options		*/

struct entry {
	char mnem[16];
};

/* symbol table and label table entries */

struct sym {
	struct sym	*next;
	word			val;
	byte			used;
	char			name[1];
};

typedef	struct sym *	SYM_PTR;

/* register name entries */

struct regent {
   char dent[8];
};

/* end of d48.h */

